-- Similar to what's used for ScreenSelectMusic, but smaller-scale
local musicStart = false

local function DelayHandling(self, deltaTime)
	if not SOUND:IsTimingDelayed() and not musicStart then
		musicStart = true
		self:GetChild("video"):play()
	end
end

local t = Def.ActorFrame{
	InitCommand=function(self)
		self:SetUpdateFunction(DelayHandling)
	end,
	LoadActor("eksd title V1") .. {
		Name = "video",
		InitCommand=function(self)
			self:pause():scaletocover(0,0,_screen.w,_screen.h)
		end,
	}
}

return t
